/* SigmaStar trade secret */
/*
* cmd_verifyaes.c - Sigmastar
*
* Copyright (C) 2018 Sigmastar Technology Corp.
*
* Author: karl.xiao <karl.xiao@sigmastar.com.tw>
*
* This software is licensed under the terms of the GNU General Public
* License version 2, as published by the Free Software Foundation, and
* may be copied, distributed, and modified under those terms.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
*/
#include <common.h>
#include <command.h>
#include <environment.h>
#include <malloc.h>
#include "asm/arch/mach/ms_types.h"
#include "asm/arch/mach/platform.h"
#include "asm/arch/mach/io.h"
#include <drvAESDMA.h>

extern void Dump_data(void*    addr, int size);
extern int Compare_data(char*    dst, char* src, int size);



/***********************************************************/
char __attribute__ ((aligned (64)))  in_buf[128] = {0};
char __attribute__ ((aligned (64))) out_buf[128] = {0};


    
/* From NIST Special Publication 800-38A, Appendix F.5 */
char __attribute__ ((aligned (16))) aes_ctr_plaintext[] = {
    "\x6b\xc1\xbe\xe2\x2e\x40\x9f\x96"
    "\xe9\x3d\x7e\x11\x73\x93\x17\x2a"
    "\xae\x2d\x8a\x57\x1e\x03\xac\x9c"
    "\x9e\xb7\x6f\xac\x45\xaf\x8e\x51"
    "\x30\xc8\x1c\x46\xa3\x5c\xe4\x11"
    "\xe5\xfb\xc1\x19\x1a\x0a\x52\xef"
    "\xf6\x9f\x24\x45\xdf\x4f\x9b\x17"
    "\xad\x2b\x41\x7b\xe6\x6c\x37\x10"
    };
char __attribute__ ((aligned (16))) aes_ctr_key[] = {
    "\x2b\x7e\x15\x16\x28\xae\xd2\xa6"
    "\xab\xf7\x15\x88\x09\xcf\x4f\x3c"
    };
char __attribute__ ((aligned (16))) aes_ctr_iv[] = {
    "\xf0\xf1\xf2\xf3\xf4\xf5\xf6\xf7"
    "\xf8\xf9\xfa\xfb\xfc\xfd\xfe\xff"
    };
char __attribute__ ((aligned (16))) aes_ctr_result[] = {
    "\x87\x4d\x61\x91\xb6\x20\xe3\x26"
    "\x1b\xef\x68\x64\x99\x0d\xb6\xce"
    "\x98\x06\xf6\x6b\x79\x70\xfd\xff"
    "\x86\x17\x18\x7b\xb9\xff\xfd\xff"
    "\x5a\xe4\xdf\x3e\xdb\xd5\xd3\x5e"
    "\x5b\x4f\x09\x02\x0d\xb0\x3e\xab"
    "\x1e\x03\x1d\xda\x2f\xbe\x03\xd1"
    "\x79\x21\x70\xa0\xf3\x00\x9c\xee"
    };
int aes_ctr_ilen   = 64;
int aes_ctr_rlen   = 64;


void verify_ctr_aes_encrypt(void)
{
    aesdmaConfig config={0};
    int in_size;

    printf("\nTest AES-CTR encryption ");


    in_size = aes_ctr_ilen;
    memcpy(in_buf, aes_ctr_plaintext, in_size);

    config.u32SrcAddr=(U32)in_buf;
    config.u32DstAddr=(U32)out_buf;
    config.u32Size=in_size;
    config.eKeyType=E_AESDMA_KEY_CIPHER;
    config.pu16Key = (U16 *)aes_ctr_key;
    config.pu16IV = (U16 *)aes_ctr_iv;
    config.bSetIV = 1;  
    config.eChainMode=E_AESDMA_CHAINMODE_CTR;
    MDrv_AESDMA_Run(&config);


    if(Compare_data(out_buf, aes_ctr_result, config.u32Size))
    {
        printf("Failed\n");
        Dump_data(out_buf, config.u32Size);
    }
    else
    {
        printf("passed!!\n");
    }

}

void verify_ctr_aes_decrypt(void)
{
    aesdmaConfig config={0};

    int in_size;

    printf("\nTest AES-CTR decryption ");
    in_size = aes_ctr_rlen;
    memcpy(in_buf, aes_ctr_result, in_size);

    config.u32SrcAddr=(U32)in_buf;
    config.u32DstAddr=(U32)out_buf;
    config.u32Size=in_size;
    config.eKeyType=E_AESDMA_KEY_CIPHER;
    config.pu16Key = (U16 *)aes_ctr_key;
    config.pu16IV = (U16 *)aes_ctr_iv;
    config.bSetIV = 1;
    config.eChainMode=E_AESDMA_CHAINMODE_CTR;

    MDrv_AESDMA_Run(&config);

    if(Compare_data(out_buf, aes_ctr_plaintext, config.u32Size))
    {
        printf("Failed\n");
        Dump_data(out_buf, config.u32Size);
    }
    else
    {
        printf("passed!!\n");
    }

}

/***********************************************************/


char __attribute__ ((aligned (16))) aes_cbc_plaintext[]  = {
    "\x00\x01\x02\x03\x04\x05\x06\x07"
    "\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
    "\x10\x11\x12\x13\x14\x15\x16\x17"
    "\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f"
    };
char __attribute__ ((aligned (16))) aes_cbc_key[]  = {
    "\xc2\x86\x69\x6d\x88\x7c\x9a\xa0"
    "\x61\x1b\xbb\x3e\x20\x25\xa4\x5a"
    };
char __attribute__ ((aligned (16))) aes_cbc_iv[] = {
    "\x56\x2e\x17\x99\x6d\x09\x3d\x28"
    "\xdd\xb3\xba\x69\x5a\x2e\x6f\x58"
    };
char __attribute__ ((aligned (16))) aes_cbc_result[] = {
    "\xd2\x96\xcd\x94\xc2\xcc\xcf\x8a"
    "\x3a\x86\x30\x28\xb5\xe1\xdc\x0a"
    "\x75\x86\x60\x2d\x25\x3c\xff\xf9"
    "\x1b\x82\x66\xbe\xa6\xd6\x1a\xb1"
    };
int aes_cbc_ilen   = 32;
int aes_cbc_rlen   = 32;

void verify_cbc_aes_encrypt(void)
{
    aesdmaConfig config={0};

    int in_size;

    printf("\nTest AES-CBC encryption ");

    in_size = aes_cbc_ilen;
    memcpy(in_buf, aes_cbc_plaintext, in_size);

    config.u32SrcAddr = (U32)in_buf;
    config.u32DstAddr = (U32)out_buf;
    config.u32Size = in_size;
    config.eKeyType = E_AESDMA_KEY_CIPHER;
    config.pu16Key = (U16 *)aes_cbc_key;
    config.pu16IV = (U16 *)aes_cbc_iv;
    config.bSetIV = 1;
    config.eChainMode=E_AESDMA_CHAINMODE_CBC;

    MDrv_AESDMA_Run(&config);

    if(Compare_data(out_buf, aes_cbc_result, config.u32Size))
    {
        printf("Failed\n");
        Dump_data(out_buf, config.u32Size);
    }
    else
    {
        printf("passed!!\n");
    }

}

void verify_cbc_aes_decrypt(void)
{
    aesdmaConfig config={0};

    int in_size;

    printf("\nTest AES-CBC decryption ");

    in_size = aes_cbc_rlen;
    memcpy(in_buf, aes_cbc_result, in_size);

    config.u32SrcAddr = (U32)in_buf;
    config.u32DstAddr = (U32)out_buf;
    config.u32Size = in_size;
    config.eKeyType = E_AESDMA_KEY_CIPHER;
    config.pu16Key = (U16 *)aes_cbc_key;
    config.pu16IV = (U16 *)aes_cbc_iv;
    config.bSetIV = 1;
    config.bDecrypt = 1;
    config.eChainMode = E_AESDMA_CHAINMODE_CBC;
    MDrv_AESDMA_Run(&config);

    if(Compare_data(out_buf, aes_cbc_plaintext, config.u32Size))
    {
        printf("Failed\n");
        Dump_data(out_buf, config.u32Size);
    }
    else
    {
        printf("passed!!\n");
    }


}

/***********************************************************/

/* From FIPS-197 */
char __attribute__ ((aligned (16))) aes_ecb_plaintext[]  = {
    "\x00\x11\x22\x33\x44\x55\x66\x77"
    "\x88\x99\xaa\xbb\xcc\xdd\xee\xff"
    "\x00\x11\x22\x33\x44\x55\x66\x77"
    "\x88\x99\xaa\xbb\xcc\xdd\xee\xff"
    };
char __attribute__ ((aligned (16))) aes_ecb_key[]  = {
    "\x00\x01\x02\x03\x04\x05\x06\x07"
    "\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
    };
char __attribute__ ((aligned (16))) aes_ecb_result[]  = {
    "\x69\xc4\xe0\xd8\x6a\x7b\x04\x30"
    "\xd8\xcd\xb7\x80\x70\xb4\xc5\x5a"
    "\x69\xc4\xe0\xd8\x6a\x7b\x04\x30"
    "\xd8\xcd\xb7\x80\x70\xb4\xc5\x5a"
    };
int aes_ecb_ilen   = 32;
int aes_ecb_rlen   = 32;

void verify_ecb_aes_encrypt(void)
{
    aesdmaConfig config={0};

    int in_size;

    printf("\nTest AES-ECB encryption ");
    in_size = aes_ecb_ilen;
    memcpy(in_buf, aes_ecb_plaintext, in_size);


    config.u32SrcAddr=(U32)in_buf;
    config.u32DstAddr=(U32)out_buf;
    config.u32Size=in_size;
    config.eKeyType=E_AESDMA_KEY_CIPHER;
    config.pu16Key = (U16 *)aes_ecb_key;
    //config.pu16IV = (U16 *)aes_iv;
    //config.bSetIV = 1;  
    config.eChainMode=E_AESDMA_CHAINMODE_ECB;
    MDrv_AESDMA_Run(&config);

    if(Compare_data(out_buf, aes_ecb_result, config.u32Size))
    {
        printf("Failed\n");
        Dump_data(out_buf, config.u32Size);
    }
    else
    {
        printf("passed!!\n");
    }

}

void verify_ecb_aes_decrypt(void)
{
    aesdmaConfig config={0};

    int in_size;

    printf("\nTest AES-ECB decryption ");
    in_size = aes_ecb_rlen;
    memcpy(in_buf, aes_ecb_result, in_size);

    config.u32SrcAddr=(U32)in_buf;
    config.u32DstAddr=(U32)out_buf;
    config.u32Size=in_size;
    config.eKeyType=E_AESDMA_KEY_CIPHER;
    config.pu16Key = (U16 *)aes_ecb_key;
    //config.pu16IV = (U16 *)aes_iv;
    //config.bSetIV = 1;
    config.bDecrypt = 1;
    config.eChainMode=E_AESDMA_CHAINMODE_ECB;
    MDrv_AESDMA_Run(&config);
    //printf("size %d\n", config.u32Size);

    if(Compare_data(out_buf, aes_ecb_plaintext, config.u32Size))
    {
        printf("Failed\n");
        Dump_data(out_buf, config.u32Size);
    }
    else
    {
        printf("passed!!\n");
    }


}

/***********************************************************/

char __attribute__ ((aligned (4))) RSA_plaintext[] = 
{
    0x31, 0x5d, 0xfa, 0x52, 0xa4, 0x93, 0x52, 0xf8, 0xf5, 0xed, 0x39, 0xf4, 0xf8, 0x23, 0x4b, 0x30,
    0x11, 0xa2, 0x2c, 0x5b, 0xa9, 0x8c, 0xcf, 0xdf, 0x19, 0x66, 0xf5, 0xf5, 0x1a, 0x6d, 0xf6, 0x25,
    0x89, 0xaf, 0x06, 0x13, 0xdc, 0xa4, 0xd4, 0x0b, 0x3c, 0x1c, 0x4f, 0xb9, 0xd3, 0xd0, 0x63, 0x29,
    0x2a, 0x5d, 0xfe, 0xb6, 0x99, 0x20, 0x58, 0x36, 0x2b, 0x1d, 0x57, 0xf4, 0x71, 0x38, 0xa7, 0x8b,
    0xad, 0x8c, 0xef, 0x1f, 0x2f, 0xea, 0x4c, 0x87, 0x2b, 0xd7, 0xb8, 0xc8, 0xb8, 0x09, 0xcb, 0xb9,
    0x05, 0xab, 0x43, 0x41, 0xd9, 0x75, 0x36, 0x4d, 0xb6, 0x8a, 0xd3, 0x45, 0x96, 0xfd, 0x9c, 0xe8,
    0x6e, 0xc8, 0x37, 0x5e, 0x4f, 0x63, 0xf4, 0x1c, 0x18, 0x2c, 0x38, 0x79, 0xe2, 0x5a, 0xe5, 0x1d,
    0x48, 0xf6, 0xb2, 0x79, 0x57, 0x12, 0xab, 0xae, 0xc1, 0xb1, 0x9d, 0x11, 0x4f, 0xa1, 0x4d, 0x1b,
    0x4c, 0x8c, 0x3a, 0x2d, 0x7b, 0x98, 0xb9, 0x89, 0x7b, 0x38, 0x84, 0x13, 0x8e, 0x3f, 0x3c, 0xe8,
    0x59, 0x26, 0x90, 0x77, 0xe7, 0xca, 0x52, 0xbf, 0x3a, 0x5e, 0xe2, 0x58, 0x54, 0xd5, 0x9b, 0x2a,
    0x0d, 0x33, 0x31, 0xf4, 0x4d, 0x68, 0x68, 0xf3, 0xe9, 0xb2, 0xbe, 0x28, 0xeb, 0xce, 0xdb, 0x36,
    0x1e, 0xae, 0xb7, 0x37, 0xca, 0xaa, 0xf0, 0x9c, 0x6e, 0x27, 0x93, 0xc9, 0x61, 0x76, 0x99, 0x1a,
    0x0a, 0x99, 0x57, 0xa8, 0xea, 0x71, 0x96, 0x63, 0xbc, 0x76, 0x11, 0x5c, 0x0c, 0xd4, 0x70, 0x0b,
    0xd8, 0x1c, 0x4e, 0x95, 0x89, 0x5b, 0x09, 0x17, 0x08, 0x44, 0x70, 0xec, 0x60, 0x7c, 0xc9, 0x8a,
    0xa0, 0xe8, 0x98, 0x64, 0xfa, 0xe7, 0x52, 0x73, 0xb0, 0x04, 0x9d, 0x78, 0xee, 0x09, 0xa1, 0xb9,
    0x79, 0xd5, 0x52, 0x4f, 0xf2, 0x39, 0x1c, 0xf7, 0xb9, 0x73, 0xe0, 0x3d, 0x6b, 0x54, 0x64, 0x86
};

char __attribute__ ((aligned (4))) RSA_KEYN[] =
{
    0x82, 0x78, 0xA0, 0xC5, 0x39, 0xE6, 0xF6, 0xA1, 0x5E, 0xD1, 0xC6, 0x8B, 0x9C, 0xF9, 0xC4, 0x3F,
    0xEA, 0x19, 0x16, 0xB0, 0x96, 0x3A, 0xB0, 0x5A, 0x94, 0xED, 0x6A, 0xD3, 0x83, 0xE8, 0xA0, 0xFD,
    0x01, 0x5E, 0x92, 0x2A, 0x7D, 0x0D, 0xF9, 0x72, 0x1E, 0x03, 0x8A, 0x68, 0x8B, 0x4D, 0x57, 0x55,
    0xF5, 0x2F, 0x9A, 0xC9, 0x45, 0xCF, 0x9B, 0xB7, 0xF5, 0x11, 0x94, 0x7A, 0x16, 0x0B, 0xED, 0xD9,
    0xA3, 0xF0, 0x63, 0x8A, 0xEC, 0xD3, 0x21, 0xAB, 0xCF, 0x74, 0xFC, 0x6B, 0xCE, 0x06, 0x4A, 0x51,
    0xC9, 0x7C, 0x7C, 0xA3, 0xC4, 0x10, 0x63, 0x7B, 0x00, 0xEC, 0x2D, 0x02, 0x18, 0xD5, 0xF1, 0x8E,
    0x19, 0x7F, 0xBE, 0xE2, 0x45, 0x5E, 0xD7, 0xA8, 0x95, 0x90, 0x88, 0xB0, 0x73, 0x35, 0x89, 0x66,
    0x1C, 0x23, 0xB9, 0x6E, 0x88, 0xE0, 0x7A, 0x57, 0xB0, 0x55, 0x8B, 0x81, 0x9B, 0x9C, 0x34, 0x9F,
    0x86, 0x0E, 0x15, 0x94, 0x2C, 0x6B, 0x12, 0xC3, 0xB9, 0x56, 0x60, 0x25, 0x59, 0x3E, 0x50, 0x7B,
    0x62, 0x4A, 0xD0, 0xF0, 0xB6, 0xB1, 0x94, 0x83, 0x51, 0x66, 0x6F, 0x60, 0x4D, 0xEF, 0x8F, 0x94,
    0xA6, 0xD1, 0xA2, 0x80, 0x06, 0x24, 0xF2, 0x6E, 0xD2, 0xC7, 0x01, 0x34, 0x8D, 0x2B, 0x6B, 0x03,
    0xF7, 0x05, 0xA3, 0x99, 0xCC, 0xC5, 0x16, 0x75, 0x1A, 0x81, 0xC1, 0x67, 0xA0, 0x88, 0xE6, 0xE9,
    0x00, 0xFA, 0x62, 0xAF, 0x2D, 0xA9, 0xFA, 0xC3, 0x30, 0x34, 0x98, 0x05, 0x4C, 0x1A, 0x81, 0x0C,
    0x52, 0xCE, 0xBA, 0xD6, 0xEB, 0x9C, 0x1E, 0x76, 0x01, 0x41, 0x6C, 0x34, 0xFB, 0xC0, 0x83, 0xC5,
    0x4E, 0xB3, 0xF2, 0x5B, 0x4F, 0x94, 0x08, 0x33, 0x87, 0x5E, 0xF8, 0x39, 0xEF, 0x7F, 0x72, 0x94,
    0xFF, 0xD7, 0x51, 0xE8, 0xA2, 0x5E, 0x26, 0x25, 0x5F, 0xE9, 0xCC, 0x2A, 0x7D, 0xAC, 0x5B, 0x35
};

char __attribute__ ((aligned (4))) RSA_KEY_PrivateE[] =
{
    0x49, 0x7E, 0x93, 0xE9, 0xA5, 0x7D, 0x42, 0x0E, 0x92, 0xB0, 0x0E, 0x6C, 0x94, 0xC7, 0x69, 0x52,
    0x2B, 0x97, 0x68, 0x5D, 0x9E, 0xB2, 0x7E, 0xA6, 0xF7, 0xDF, 0x69, 0x5E, 0xAE, 0x9E, 0x7B, 0x19,
    0x2A, 0x0D, 0x50, 0xBE, 0xD8, 0x64, 0xE7, 0xCF, 0xED, 0xB2, 0x46, 0xE4, 0x2F, 0x1C, 0x29, 0x07,
    0x45, 0xAF, 0x44, 0x3C, 0xFE, 0xB3, 0x3C, 0xDF, 0x7A, 0x10, 0x26, 0x18, 0x43, 0x95, 0x02, 0xAD,
    0xA7, 0x98, 0x81, 0x2A, 0x3F, 0xCF, 0x8A, 0xD7, 0x12, 0x6C, 0xAE, 0xC8, 0x37, 0x6C, 0xF9, 0xAE,
    0x6A, 0x96, 0x52, 0x4B, 0x99, 0xE5, 0x35, 0x74, 0x93, 0x87, 0x76, 0xAF, 0x08, 0xB8, 0x73, 0x72,
    0x7D, 0x50, 0xA5, 0x81, 0x26, 0x5C, 0x8F, 0x94, 0xEA, 0x73, 0x59, 0x5C, 0x33, 0xF9, 0xC3, 0x65,
    0x1E, 0x92, 0xCD, 0x20, 0xC3, 0xBF, 0xD7, 0x8A, 0xCF, 0xCC, 0xD0, 0x61, 0xF8, 0xFB, 0x1B, 0xF4,
    0xB6, 0x0F, 0xD4, 0xCF, 0x3E, 0x55, 0x48, 0x4C, 0x99, 0x2D, 0x40, 0x44, 0x7C, 0xBA, 0x7B, 0x6F,
    0xDB, 0x5D, 0x71, 0x91, 0x2D, 0x93, 0x80, 0x19, 0xE3, 0x26, 0x5D, 0x59, 0xBE, 0x46, 0x6D, 0x90,
    0x4B, 0xDF, 0x72, 0xCE, 0x6C, 0x69, 0x72, 0x8F, 0x5B, 0xA4, 0x74, 0x50, 0x2A, 0x42, 0x95, 0xB2,
    0x19, 0x04, 0x88, 0xD7, 0xDA, 0xBB, 0x17, 0x23, 0x69, 0xF4, 0x52, 0xEB, 0xC8, 0x55, 0xBE, 0xBC,
    0x2E, 0xA9, 0xD0, 0x57, 0x7D, 0xC6, 0xC8, 0x8B, 0x86, 0x7B, 0x73, 0xCD, 0xE4, 0x32, 0x79, 0xC0,
    0x75, 0x53, 0x53, 0xE7, 0x59, 0x38, 0x0A, 0x8C, 0xEC, 0x06, 0xA9, 0xFC, 0xA5, 0x15, 0x81, 0x61,
    0x3E, 0x44, 0xCD, 0x05, 0xF8, 0x54, 0x04, 0x00, 0x79, 0xB2, 0x0D, 0x69, 0x2A, 0x47, 0x60, 0x1A,
    0x2B, 0x79, 0x3D, 0x4B, 0x50, 0x8A, 0x31, 0x72, 0x48, 0xBB, 0x75, 0x78, 0xD6, 0x35, 0x90, 0xE1,
};

char __attribute__ ((aligned (4))) RSA_KEY_PublicE[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01
};

void verify_rsa(void)
{
    U8 rsa_encrypt_out[256];
    U8 rsa_decrypt_out[256];

    memset(rsa_encrypt_out, 0 , sizeof(rsa_encrypt_out));
    memset(rsa_decrypt_out, 0 , sizeof(rsa_decrypt_out));


    printf("\nTest %s encrypt\n", __FUNCTION__);
    {
        rsaConfig config={0};
        config.pu32KeyN = (U32 *)RSA_KEYN;
        config.pu32KeyE = (U32 *)RSA_KEY_PrivateE;
        config.u32KeyLen = 256;
        config.pu32Sig = (U32*)(RSA_plaintext);
        config.u32SigLen = sizeof(RSA_plaintext);
        config.pu32Output = (U32 *)rsa_encrypt_out;
        MDrv_RSA_Run(&config);
    }


    printf("Test %s decrypt\n", __FUNCTION__);
    {
        rsaConfig config={0};
        config.pu32KeyN = (U32 *)RSA_KEYN;
        config.pu32KeyE = (U32 *)RSA_KEY_PublicE;
        config.u32KeyLen = 256;
        config.pu32Sig = (U32*)(rsa_encrypt_out);
        config.u32SigLen = sizeof(rsa_encrypt_out);
        config.pu32Output = (U32 *)rsa_decrypt_out;
        MDrv_RSA_Run(&config);
    }


    if(Compare_data((char*)RSA_plaintext, (char*)rsa_decrypt_out, 256))
    {
        printf("Failed\n");
        printf("RSA_plaintext:\n");
        Dump_data(RSA_plaintext, 256);
        printf("rsa_encrypt_out:\n");
        Dump_data(rsa_encrypt_out, 256);
        printf("rsa_decrypt_out:\n");
        Dump_data(rsa_decrypt_out, 256);
    }
    else
    {
        printf("passed!!\n");
    }

}

/***********************************************************/

char __attribute__ ((aligned (16))) sha_plaintext[] = 
    "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq";
int sha_psize  = 56;
char sha_digest[] = 
    "\x24\x8d\x6a\x61\xd2\x06\x38\xb8"
    "\xe5\xc0\x26\x93\x0c\x3e\x60\x39"
    "\xa3\x3c\xe4\x59\x64\xff\x21\x67"
    "\xf6\xec\xed\xd4\x19\xdb\x06\xc1";


void verify_sha(void)
{
    char __attribute__ ((aligned (16))) out_buf[128] = {0};

    printf("\nTest %s ", __FUNCTION__);


    MDrv_SHA_Run((U32)sha_plaintext, sha_psize, E_SHA_MODE_256, (U16*)out_buf);

    if(Compare_data(out_buf, sha_digest, 32))
    {
        printf("Failed\n");
        Dump_data(out_buf, 32);
    }
    else
    {
        printf("passed!!\n");
    }

}

int do_verifyaes(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{

    verify_ctr_aes_encrypt();
    verify_ctr_aes_decrypt();
    verify_cbc_aes_encrypt();
    verify_cbc_aes_decrypt();
    verify_ecb_aes_encrypt();
    verify_ecb_aes_decrypt();
    
    verify_rsa();

    verify_sha();
    return CMD_RET_SUCCESS;
}

U_BOOT_CMD(
	verifyaes, CONFIG_SYS_MAXARGS, 1,	do_verifyaes,
	"verifyaes - Verify AES/RSA/SHA function\n",
    ""
);
